% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{POTextract}
\alias{POTextract}
\title{Peaks over threshold (POT) data extraction}
\usage{
POTextract(x, div = NULL, thresh = 0.975, Plot = TRUE)
}
\arguments{
\item{x}{either a numeric vector or dataframe with date in the first column and hydrological variable in the second}

\item{div}{user chosen value, either side of which two peaks over the threshold are considered independent. Default is the mean of the sample}

\item{thresh}{user chosen threshold. Default is 0.975}

\item{Plot}{logical argument with a default of TRUE. When TRUE, the full hydrograph with the peaks over the threshold highlighted is plotted}
}
\value{
Prints the number of peaks per year and returns a data.frame with columns; Date and peak, with the option of a plot. Or a numeric vector of peaks is returned if only a numeric vector of the hydrological variable is input.
}
\description{
Extracts independent peaks over a threshold from a sample
}
\details{
If the x argument is a numeric vector, the peaks will be extracted with no time information. x can instead be a data.frame with dates in the first column and the numeric vector in the second. In this latter case, the peaks will be timestamped and a hydrograph including POT will be plotted by default. The method of extracting independent peaks assumes that there is a value either side of which, events can be considered independent. For example, if two peaks above the chosen threshold are separated by the daily mean flow, they could be considered independent, but not if flow hasn't returned to daily mean at any time between the peaks. Daily mean flow may not always be appropriate, in which case the 'div' argument can be adjusted. In some cases, where the baseflow component is very high, there won't be more than one independent peak per year, rendering the AM extraction and block maxim method preferable. A good example of this would be the River Alre at Drove Lane Alresford. The function was coded primarily for river flow but for extracting daily duration POT rainfall a div of zero could be used (making the assumption that rainfall events separated by a period of 24 hours, with no rain, are independent). For sub-daily rainfall, further work, after use of the function, would be necessary. For example, a div of zero could be used, and if two peaks are extracted but not separted by more than 24 hours, the lower of the two could be discarded. For this approach a data.frame with dates would be required. When plotted, the blue line is the threshold and the green line is the independence line (div).
}
\examples{
#Extract POT data from Thames mean daily flow 1970-10-01 to 2015-09-25 with
#div = mean and threshold = 0.95. Then display the first six rows
ThamesQPOT <- POTextract(ThamesPQ[, c(1,3)], thresh = 0.90)
head(ThamesQPOT)
#Extract Thames POT from only the numeric vector of flows and display the
#first six rows
ThamesQPOT <- POTextract(ThamesPQ[, 3], thresh = 0.90)
ThamesQPOT
#Extract the Thames POT precipitation with a div of 0 and the default
#threshold. Then display the first six rows
ThamesPPOT <- POTextract(ThamesPQ[, c(1,2)], div = 0)
head(ThamesPPOT)
}
\author{
Anthony Hammond
}
