% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{DDFImport}
\alias{DDFImport}
\title{DDF13 or DDF22 results from .xml files}
\usage{
DDFImport(x, ARF = FALSE, Plot = TRUE, DDFVersion = 22)
}
\arguments{
\item{x}{the xml file path}

\item{ARF}{logical argument with a default of FALSE. If TRUE, the areal reduction factor is applied to the results. If FALSE, no area reduction factor is applied}

\item{Plot}{logical argument with a default of TRUE. If TRUE the DDF curve is plotted for a few return periods}

\item{DDFVersion}{Version of the DDF model (numeric). either 22 or 13. The default is 22.}
}
\value{
A data frame of DDF13 results (mm) with columns for duration and rows for return period. If Plot equals TRUE a DDF plot is also returned
}
\description{
Imports the depth duration frequency 2013 or 2022 results from xml files either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
This function returns a data-frame of results. For further durations and return periods the DDF function can be applied with the data-frame as the argument/input. File paths for importing data require forward slashes. On some operating systems, such as windows, the copy and pasted file paths will have backward slashes and would need to be changed accordingly.
}
\examples{
#Import DDF13 results from a NRFA peakflows xml file and display in console
\dontrun{DDF13.4003 <- DDF13Import("C:/Data/NRFAPeakFlow_v11/Suitable for QMED/04003.xml")}
\dontrun{DDF13.4003}
#Import DDF13 results from a FEH webserver xml file and display in the console
\dontrun{DDF13.MySite <- DDF13Import("C:/Data/FEH_Catchment_384200_458200.xml")}
}
\author{
Anthony Hammond
}
