% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMRgradDesc_fixed_df.R
\name{UMRgradDesc_fixed_df}
\alias{UMRgradDesc_fixed_df}
\title{Gradient Descent with a fixed number of constant pieces (degrees of
    freedom)}
\usage{
UMRgradDesc_fixed_df(
  grad,
  init,
  stepsize,
  MM,
  tol = 1e-07,
  printevery = Inf,
  filename
)
}
\arguments{
\item{grad}{a function(mm) where mm
is the previous iterate value (i.e., the estimate vector).}

\item{init}{Initial value  of estimate  ('mm').   The output will be of length length(init).}

\item{stepsize}{Gradient descent stepsize.  Set carefully!}

\item{MM}{Number of iterations  in which "support reduction" (combining of
approximately equal  values into a  region of constancy) is  done (see
details and paper).  Depending on tol, may not use all MM iterations.}

\item{tol}{Tolerance: end algorithm  once sum(abs(mm-mmprev)) < tol or you
hit MM iterations.}

\item{printevery}{integer  value (generally  << MM).   Every 'printevery'
iterations, a count will be printed and the output saved.}

\item{filename}{path1/path2/filename to save output to.}
}
\description{
Gradient Descent with a fixed number of constant pieces (degrees of
    freedom)
}
\details{
UMRgradDesc_fixed_df does a gradient descent with a fixed (upper bound) on the number of constant segments of the function. 

Output of UMRgradDesc_fixed_df  is unsorted.  Note weights for  'mm' are not
passed in; rather they will be contained/used in grad().
}
