% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COEF.R
\name{coef.UPG.Binomial}
\alias{coef.UPG.Binomial}
\title{Extract coefficients from UPG.Binomial objects}
\usage{
\method{coef}{UPG.Binomial}(object, ..., q = c(0.025, 0.975))
}
\arguments{
\item{object}{an object of class \code{UPG.Binomial}.}

\item{...}{other coef parameters.}

\item{q}{a numerical vector of length two holding the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}
}
\value{
Returns a matrix containing posterior means and the desired credible interval.
}
\description{
\code{coef} can be used to extract posterior means and credible intervals based on posterior quantiles from \code{UPG.Binomial} objects.
}
\examples{
\donttest{
# estimate a binomial logit model using example data
library(UPG)
data(titanic)
y  = titanic[,1]
Ni = titanic[,2]
X  = titanic[,-c(1,2)]
results.binomial = UPG(y = y, X = X, Ni = Ni, type = "binomial")

# extract posterior means and credible interval based on 0.025 and 0.975 quantiles
coef(results.binomial, q = c(0.025, 0.975))
}
}
\seealso{
\code{\link{summary.UPG.Binomial}} to summarize the estimates of a discrete choice model from an \code{UPG.Binomial} object and create tables.
\code{\link{predict.UPG.Binomial}} to predict probabilities from a discrete choice model from an \code{UPG.Binomial} object.
\code{\link{plot.UPG.Binomial}} to plot the results of a discrete choice model from an \code{UPG.Binomial} object.
}
\author{
Gregor Zens
}
