% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varEst_class3.R
\name{var_MateiTille}
\alias{var_MateiTille}
\title{Approximate Variance Estimators by Matei and Tillé (2005)}
\usage{
var_MateiTille(y, pik, method, sample, maxIter = 1000, eps = 1e-05)
}
\arguments{
\item{y}{numeric vector of sample observations}

\item{pik}{numeric vector of first-order inclusion probabilities for all population units}

\item{method}{string indicating the desired approximate variance estimator.
One of "Deville1", "Deville2", "Deville3", "Hajek", "Rosen", "FixedPoint",
"Brewer1", "HartleyRao", "Berger", "Tille", "MateiTille1", "MateiTille2",
"MateiTille3", "MateiTille4", "MateiTille5", "Brewer2", "Brewer3", "Brewer4".}

\item{sample}{Either a numeric vector of length equal to the sample size with
the indices of sample units, or a boolean vector of the same length of \code{pik}, indicating which
units belong to the sample (\code{TRUE} if the unit is in the sample,
\code{FALSE} otherwise.
Only used with estimators of the third class (see Details for more information).}

\item{maxIter}{a scalar indicating the maximum number of iterations for the
fixed-point procedure}

\item{eps}{tolerance value for the convergence of the fixed-point procedure}
}
\value{
a scalar, the estimated variance
}
\description{
Computes an approximate variance estimate according to
one of the estimators proposed by Matei and Tillé (2005)
Estimators of class 3, they require only first-order inclusion probabilities but
for all population units.
}
\keyword{internal}
