% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOptimalUT.R
\name{GetOptimalUT}
\alias{GetOptimalUT}
\title{Gives the dose to assign the next patient cohort using monotone utility based phase 12 trial.}
\usage{
GetOptimalUT(YE, YT, Doses, DoseTried, AR, UT, CutE, CutT, AcceptE,
  AcceptT, HypermeansE, HypermeansT, Hypervars)
}
\arguments{
\item{YE}{Vector of patient efficacy status.}

\item{YT}{Vector of patient toxicity status.}

\item{Doses}{Vector of patient dose assignment.}

\item{DoseTried}{Vector containing 1s for doses tried and 0 otherwise.}

\item{AR}{Logical stating whether or not to adaptively randomize the next cohort of patients. If the trial has been completed, AR equals FALSE will give the optimal dose level for the trial.}

\item{UT}{Utility Matrix with entries U11, U22 elicited and U12 equals 100, U21 equals 0.}

\item{CutE}{Cutoff for efficacy acceptability.}

\item{CutT}{Cutoff for toxicity acceptability.}

\item{AcceptE}{Probability threshold for efficacy acceptability.}

\item{AcceptT}{Probability threshold for toxicity acceptability.}

\item{HypermeansE}{Dose-specific hypermeans for efficacy.}

\item{HypermeansT}{Dose-specific hypermeans for toxcity.}

\item{Hypervars}{Length 3 vector of hypervariances. Hypervars[1] contains the Latent parameter variance for normal probability of efficacy and toxicity. Hypervars[2] contains the hypervariance on dose specific mean efficacy and toxicity parameters and Hypervars[3] contains the frailty variance parameter.}
}
\value{
A numerical value of the dose to assign the next patient cohort to. If the trial has been completed, this is the optimal dose. If a value of 0 is returned, no doses are acceptable and the trial should be stopped.
}
\description{
Gives the dose to assign the next patient cohort using the monotone utility based phase 12 trial using either adaptive randomization or fixed dose assignment. If the trial has been completed, AR equals FALSE will give the optimal dose level for the trial.
}
\examples{
library(mvtnorm)
##Data Here
YE=rbinom(30,1,.8)
YT=rbinom(30,1,.3)
Doses=sample(1:3,30,replace=TRUE)
DoseTried=c(1,1,1,0,0)
##UTILITIES
UT = matrix(c(38.23529,100,0,61.76471),nrow=2,byrow=TRUE)
##Safety Parameters
CutE=.3
CutT=.4
AcceptE=.1
AcceptT=.1
##Hyperparameters for Utility
HypermeansE=c(-1.189, -0.357,  0.360,  0.546,  0.743)
HypermeansT=c(-2.325, -1.811, -1.464, -1.189, -0.740)
Hypervars=c(1,36,1)  
##Adaptively randomize or not?
AR=FALSE
GetOptimalUT( YE,YT, Doses,DoseTried,AR, UT, CutE, CutT,
AcceptE, AcceptT, HypermeansE, HypermeansT,Hypervars)
}
