% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{first.step.blocks.group}
\alias{first.step.blocks.group}
\title{block fused sparse group lasso step (first step).}
\usage{
first.step.blocks.group(
  data.temp,
  lambda.1.cv,
  lambda.2.cv,
  q,
  max.iteration = max.iteration,
  tol = tol,
  cv.index,
  blocks,
  group.case = "columnwise",
  group.index
)
}
\arguments{
\item{data.temp}{input data matrix, with each column representing the time series component}

\item{lambda.1.cv}{tuning parmaeter lambda_1 for fused lasso}

\item{lambda.2.cv}{tuning parmaeter lambda_2 for fused lasso}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{cv.index}{the index of time points for cross-validation}

\item{blocks}{the blocks}

\item{group.case}{group sparse pattern: column, row.}

\item{group.index}{group index for group sparse case}
}
\value{
A list object, which contains the followings
\describe{
  \item{brk.points}{a set of selected break point after the first block fused lasso step}
  \item{cv}{the cross validation values for tuning parmeter selection}
  \item{cv1.final}{the selected lambda_1}
  \item{cv2.final}{the selected lambda_2}
}
}
\description{
Perform the block fused lasso to detect candidate break points.
}
