% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{eval_func}
\alias{eval_func}
\title{Evaluation function, return the performance of simulation results}
\usage{
eval_func(true_mats, est_mats)
}
\arguments{
\item{true_mats}{a list of true matrices for all segments, the length of list equals to the true number of segments}

\item{est_mats}{a list of estimated matrices for all simulation replications, for each element, it is a list of numeric matrices,
representing the estimated matrices for segments}
}
\value{
A list, containing the results for all measurements
\describe{
    \item{sensitivity}{A numeric vector, containing all the results for sensitivity over all replications}
    \item{specificity}{A numeric vector, including all the results for specificity over all replications}
    \item{accuracy}{A numeric vector, the results for accuracy over all replications}
    \item{mcc}{A numeric vector, the results for Matthew's correlation coefficients over all replications}
    \item{false_reps}{An integer vector, recording all the replications which falsely detects the change points, over-detect or under-detect}
}
}
\description{
Evaluation function, return the performance of simulation results
}
\examples{
true_mats <- vector('list', 2)
true_mats[[1]] <- matrix(c(1, 0, 0.5, 0.8), 2, 2, byrow = TRUE)
true_mats[[2]] <- matrix(c(0, 0, 0, 0.75), 2, 2, byrow = TRUE)
est_mats <- vector('list', 5)
for(i in 1:5){
    est_mats[[i]] <- vector('list', 2)
    est_mats[[i]][[1]] <- matrix(sample(c(0, 1, 2), size = 4, replace = TRUE), 2, 2, byrow = TRUE)
    est_mats[[i]][[2]] <- matrix(sample(c(0, 1), size = 4, replace = TRUE), 2, 2, byrow = TRUE)
}
perf_eval <- eval_func(true_mats, est_mats)
}
