% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmer.ts.R
\name{fit.varmer}
\alias{fit.varmer}
\title{Training eta parameter for the varmer function}
\usage{
fit.varmer(
  stations.sf,
  v,
  etas = c(10, 100, 500, 1000, 5000),
  idw_formula = Variable ~ 1,
  factor_agg = 2,
  drty.out = tempdir(),
  apply_varmer = T
)
}
\arguments{
\item{stations.sf}{data.frame with the observations metadata}

\item{v}{grided image}

\item{etas}{(optional) vector of eta values to evaluate in a CV exercise}

\item{idw_formula}{formula for the idw interpolation}

\item{factor_agg}{scalar which defines the aggregation factor to apply to the raster images in order to reduce computation requirements for solving varmer}

\item{drty.out}{(optional) output folder for the CV metrics}

\item{apply_varmer}{(optional) boolean which determines if a merging image is produced with the best eta}
}
\description{
Training eta parameter for the varmer function evaluating a vector of
etas using Cross-validation. The best eta is the one yielding the highest
KGE metric.
}
