% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbtvisit.R
\name{vbtinq}
\alias{vbtinq}
\title{Using vector to visit vector binary tree}
\usage{
vbtinq(x, inq)
}
\arguments{
\item{x}{The vector binary tree to be visited. Traversal is available by setting -1 in desired layer.}

\item{inq}{An integer vector to determine desired location. The length of \code{inq} should be the same
as the layers of visited vector binary tree. If any assignment in specificed layer exceeds its intrinsic
length of visited vector binary tree layer, all elements will be returned in this layer.}
}
\value{
Return a double list according to the argument \code{inq}.
}
\description{
Visit the vector binary tree and return a double list through specific assigment determined
by the argument \code{inq}.
}
\examples{
#Make vector binary tree:
colnamevbt <- dl2vbt(chrvec2dl(colnames(datatest)))

#Visit by specific assignment:
vbtinq(colnamevbt, c(2, 3, 1, 1))

#Traversal of the second layers:
vbtinq(colnamevbt, c(2, -1, 1, 1))

#Invalid assignments in 1st and 3rd layers:
vbtinq(colnamevbt, c(4, 3, 7, 1))
}
\seealso{
\code{\link[VBTree:vbtsub]{vbtsub}}, \code{\link[VBTree:advbtinq]{advbtinq}}, \code{\link[VBTree:advbtsub]{advbtsub}}.
}
\keyword{Double.List}
\keyword{Vector.Binary.Tree}
