% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tawnT1Copula.R
\name{tawnT1Copula}
\alias{tawnT1Copula}
\alias{surTawnT1Copula}
\alias{r90TawnT1Copula}
\alias{r270TawnT1Copula}
\title{Constructor for Tawn copulas (type 1)}
\usage{
tawnT1Copula(param = c(2, 0.5))

surTawnT1Copula(param = c(2, 0.5))

r90TawnT1Copula(param = c(-2, 0.5))

r270TawnT1Copula(param = c(-2, 0.5))
}
\arguments{
\item{param}{The parameter \code{param} defines the copula through
\code{param1} and \code{param2}.}
}
\value{
One of the Tawn type 1 copula classes
(\linkS4class{tawnT1Copula}, \linkS4class{surTawnT1Copula},
\linkS4class{r90TawnT1Copula},
\linkS4class{r270TawnT1Copula}).
}
\description{
Constructs an object of the \linkS4class{tawnT1Copula} (survival
\code{sur}, 90 degree rotated \code{r90} and 270 degree rotated \code{r270})
family for given parameters.
}
\examples{

library(copula)

persp(tawnT1Copula(), dCopula, zlim = c(0, 10))
persp(surTawnT1Copula(), dCopula, zlim = c(0, 10))
persp(r90TawnT1Copula(), dCopula, zlim = c(0, 10))
persp(r270TawnT1Copula(), dCopula, zlim = c(0, 10))
}
\seealso{
\code{\link[=tawnT1Copula]{tawnT1Copula()}} and the package
\code{\link[=VineCopula-package]{VineCopula-package()}} for implementation details.
}
\keyword{copula}
\keyword{distribution}
