% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ve.R
\name{ve}
\alias{ve}
\title{Retrieve the Estimated Vaccine Efficacy}
\usage{
ve(x, taus)
}
\arguments{
\item{x}{An object of class VEwaning. The object returned by a call to
veWaning()}

\item{taus}{A numeric vector object. The times since vaccination at which
the vaccine efficacy is to be estimated.}
}
\value{
A matrix object. The first column contains the times since
  vaccination at which the estimates are provided; the second column
  contains estimated vaccine efficacy; and the third is the standard error.
}
\description{
Uses a prior veWaning() analysis to estimate the vaccine efficacy
  at the provided times since vaccination.
}
\examples{
data(veWaningData)

set.seed(1234)

ind <- sample(1:nrow(veWaningData), 2500)
# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.

res <- veWaning(data = veWaningData[ind,], 
                L = 52,  
                lag = 6,  
                modelGam1 = ~ X1+X2+A+A:X1+A:X2, 
                modelGam2 = ~ X1+X2, 
                modelEntry = ~ X1+X2, 
                modelPsiGam1 = ~ X1+X2, 
                modelPsiGam2 = ~ X1+X2, 
                gFunc = 'piece', 
                v = c(20))

ve(x = res, taus = c(10,20,30,40,50))
}
