% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{print.VFP}
\alias{print.VFP}
\title{Print Objects of Class 'VFP'}
\usage{
\method{print}{VFP}(x, model.no = NULL, digits = 4, ...)
}
\arguments{
\item{x}{(object) of class 'VFP'}

\item{model.no}{(integer) specifying a fitted model in 'x', if NULL the best fitting
model will be printed, i.e. the one with min(AIC)}

\item{digits}{(integer) number of significant digits}

\item{...}{additional parameters passed forward}
}
\description{
Print Objects of Class 'VFP'
}
\examples{
\donttest{
library(VCA)
data(CA19_9)
fits.CA19_9 <- anovaVCA(result~site/day, CA19_9, by="sample")
# extract repeatability
mat.CA19_9 <- getMat.VCA(fits.CA19_9, "error")
res.CA19_9 <- fit.vfp(mat.CA19_9, 1:10)
res.CA19_9
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
