% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadLd.R
\name{loadLd}
\alias{loadLd}
\title{loadLd}
\usage{
loadLd(data, type)
}
\arguments{
\item{data}{An input file. Must be a raggr generated csv file or a bed file. If a bed file, it must contain at least five columns: chr, start, end, LD_snp_id, tag_snp_id.}

\item{type}{The type of input file. Must be "bed" or "raggr".}
}
\description{
This function will load a raggr output csv or user defined bed file to GRanges object. It is recommended to generate a LD file using http://raggr.usc.edu. If you prefer to use other softwares to calculate LD SNPs (e.g., plink), please format the output to bed files. Please make sure that you use a cutoff of 0.8 for r2 value.
}
\examples{
ld<-loadLd(file.path(system.file("extdata", "ld_BCa_raggr.csv", package="VSE")), type="raggr")
}
\keyword{LD,bed,raggr,GRanges}

