% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_ias.R
\name{custom_ia}
\alias{custom_ia}
\title{Map gaze data to newly defined interest areas}
\usage{
custom_ia(data, iaLookup = NULL)
}
\arguments{
\item{data}{A data table object output by \code{\link{prep_data}}.}

\item{iaLookup}{A data frame object containing by-event mapping information.}
}
\value{
A data table object.
}
\description{
\code{custom_ia} uses a lookup data frame to map Left and Right gaze data
to newly defined/supplied interest areas for each recording event. The lookup data
should contain columns Event, IA_LABEL, IA_ID, Top, Bottom, Left, Right, which 
specify the Interest area label, its corresponding ID, and the boundaries (in
pixel values) for each recording event. The function will overwrite existing
columns RIGHT_INTEREST_AREA_LABEL, RIGHT_INTEREST_AREA_ID, 
LEFT_INTEREST_AREA_LABEL, and LEFT_INTEREST_AREA_ID.
}
\examples{
\dontrun{
library(VWPre)
# Map gaze data to newly defined interest areas...
df <- custom_ia(data = dat, iaLookup = LookUpDF)
}
}
