% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_avg_cdiff}
\alias{plot_avg_cdiff}
\title{Plots average difference between two conditions.}
\usage{
plot_avg_cdiff(data, IAColumn = NULL, xlim = NA, type = NULL,
  Averaging = "Subject", Condition = NULL, CondLabels = NA,
  ErrorBar = TRUE, VWPreTheme = TRUE, ConfLev = 95,
  CItype = "simultaneous", ErrorBand = FALSE, ErrorType = "SE")
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}}. 
\code{\link{transform_to_elogit}}, or \code{\link{create_binomial}}.}

\item{IAColumn}{A character vector specifying the desired column
corresponding to the interest area.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{type}{A character string indicating "proportion" or "elogit",
which influences how standard error and confidence intervals are calculated.}

\item{Averaging}{A character string indicating how the averaging should 
be done. "Subject" (default) will produce the grand mean in the data, while
"Item" (or, in principle, any other column name) will
calculate the grand mean by that factor.}

\item{Condition}{A list containing the column name corresponding to the 
condition and factor levels to be used for calculating the difference.}

\item{CondLabels}{A named character vector specifying the desired labels 
of the levels of the condition.}

\item{ErrorBar}{A logical indicating whether error bars should be
included in the plot.}

\item{VWPreTheme}{A logical indicating whether the theme included with the 
function should be applied, or ggplot2's base theme (to which any other 
custom theme could be added).}

\item{ConfLev}{A number indicating the confidence level of the CI.}

\item{CItype}{A string indicating "simultaneous" or "pointwise". Simultaneous
performs a Bonferroni correction for the interval.}

\item{ErrorBand}{A logical indicating whether error bands should be
included in the plot.}

\item{ErrorType}{A string indicating "SE" or "CI".}
}
\description{
\code{plot_avg_cdiff} calculates the average of differences between 
two specified conditions along with standard error and then plots the 
results.
}
\examples{
\dontrun{
library(VWPre)
# For plotting average difference between conditions...
plot_avg_cdiff(data = dat, xlim = c(0, 1000), type = "proportion",
             IAColumn = "IA_1_P", Condition = list(talker = c("EN3", "CH1")),
             CondLabels = NA, ErrorBar = TRUE, VWPreTheme = TRUE, 
             ErrorBand = FALSE, ErrorType = "SE")

# For a more complete tutorial on VWPre plotting functions:
vignette("SR_Plotting", package="VWPre")
}

}
