% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateVCM.R
\name{simulateVCM}
\alias{simulateVCM}
\title{Simulate a dataset for testing the performance of screenVCM}
\usage{
simulateVCM(n = 200, rho = 0.4, p = 1000, trueIdx = c(2, 100, 400, 600,
  1000), betaFun = NULL, sigma = 1)
}
\arguments{
\item{n}{Number of subjects in the simulated dataset}

\item{rho}{The correlation matrix of columns of X.}

\item{p}{The total number of features to be screened from}

\item{trueIdx}{The indexes for the active features in the simulated X matrix.
This should be a vector, and the values should be a subset of 1:p.}

\item{betaFun}{A list of functions of U, one function for each entry in trueIdx,
giving the varying effects of each active predictor in the simulated
X matrix.}

\item{sigma}{The error standard deviation of the response}
}
\value{
A list with following components:
     \item{X:}{Matrix of predictors to be screened. It will have n rows and p columns.}
     \item{Y:}{Vector of responses.  It will have length of n.}
     \item{U:}{A vector representing a covariate with which the coefficient functions vary.}
}
\description{
Simulates a dataset that can be used to test the screenVCM
function, and to test the performance of the proposed method under different
scenarios. The simulated dataset has a single U-covariate and p X-predictors,
only a few of which have nonzero effect.

  Jingyuan Liu for providing some of the code upon which this function is based.
}
\examples{
set.seed(12345678)
results <- simulateVCM(p=1000)
}

