% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglk_censor_MVN.R
\name{loglk_censor_MVN}
\alias{loglk_censor_MVN}
\title{Compute censored multivariate normal (MVN) log-probabilities that have
spatial covariance matrices using Vecchia approximation}
\usage{
loglk_censor_MVN(
  locs,
  indCensor,
  y,
  bCensor,
  covName = NULL,
  covParms = NULL,
  m = 30,
  NLevel1 = 10,
  NLevel2 = 1000,
  verbose = TRUE
)
}
\arguments{
\item{locs}{location (feature) matrix n X d}

\item{indCensor}{indices of locations that have only censored observations}

\item{y}{observed (not censored) values, of length n}

\item{bCensor}{upper bound, above which observations are not censored,
can be different for different locations, of length 1 or n}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{m}{Vecchia conditioning set size}

\item{NLevel1}{first level Monte Carlo sample size}

\item{NLevel2}{second level Monte Carlo sample size}

\item{verbose}{verbose level}
}
\value{
estimated MVN probability and estimation error
}
\description{
Compute censored multivariate normal (MVN) log-probabilities that have
spatial covariance matrices using Vecchia approximation
}
