\name{export.to.cytoscape}

\alias{export.to.cytoscape}

\title{Facilitates export of results of the Vertex Sort algorithm to Cytoscape}

\description{
  The \code{export.to.cytoscape()} function facilitates export of a
  graph that was sorted by the vertex sort algorithm to the Cytoscape.
  It creates a list of two data frames.  The first data frame contains the
  edges of the graph and the second data frame contains node attributes
  of the graph.  These data frames could be written to text files and
  could be imported to cytoscape to allow to query certain details of
  the results (e.g. layer of a node) and to also permit the
  visualization and customization of the graphic representation of the
  sorted graph in order to generate figures.
}

\usage{
  export.to.cytoscape(vs_object)
}

\arguments{
  \item{vs_object}{a vertex.sort object generated by applying the
  \code{vertex.sort()} function.}
}

\value{
  The \code{export.to.cytoscape()} function returns a list of two data frames:
  \item{edges}{a data frame that contains the edges of a graph that
  has been sorted using the Vertex Sort algorithm by the
  \code{vetex.sort()} function.}
  \item{node_attribute}{a data frame that contains the node attributes
  of a graph that has been sorted using the Vertex Sort algorithm by the
  \code{vetex.sort()} function.  It includes the following columns: node
  identifier, node type, node layer and node level.  For more details,
  see \code{vertex.sort()} function}
}


\references{
  Jothi, R., Balaj, S., Wuster, A. et al. 2009 \emph{Molecular system
    biology} \bold{5}, --294-309.

  Abd-Rabbo, D. and Michnick, S.W. 2017 \emph{BMC Syst Biol} \bold{11}.
}

\author{
  Diala Abd-Rabbo \email{diala.abd.rabbo@gmail.com}
}

\seealso{
  \code{\link{vertex.sort}}.
}
\examples{
  ## load interactions of the kinase-phosphatase network (kp-net)
  data("interactions")

  ## apply the vertex sort algorithm
  vs_kp_net <- vertex.sort(interactions)

  ## apply the export.to.cytoscape function
  df <- export.to.cytoscape(vs_kp_net)

  ## view the first 6 lines of each data frame
  head(df$edges)
  head(df$node_attribute)
}

\keyword{ graphs }
\keyword{ Graphics }
