% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nextprime.R
\name{20. Next prime number}
\alias{20. Next prime number}
\alias{nextprime}
\alias{nextprime.default}
\alias{nextprime.numeric}
\alias{nextprime.vli}
\title{Next Prime Number}
\usage{
nextprime(n, iter = 10, test = "MR")

\method{nextprime}{default}(n, iter = 10, test = "MR")

\method{nextprime}{numeric}(n, iter = 10, test = "MR")

\method{nextprime}{vli}(n, iter = 10, test = "MR")
}
\arguments{
\item{n}{object of class vli or 32 bits integer}

\item{iter}{number of iterations for testing whether or not each number is prime; numeric}

\item{test}{chosen test: "F" for the Fermat Test, "SS" for the Solovay-Strassen Test or "MR" (by default) for the Miller-Rabin Test; character}
}
\value{
object of class vli
}
\description{
The function \code{nextprime} computes and returns the smallest prime number that is greater than the given number.
}
\details{
The number of iterations is configurable to set the desired accuracy. A small number of iterations might cause not finding a prime number.
}
\examples{
n <- as.vli("982234568923564")
x <- nextprime(n)
x
is.prime(x)
}
\author{
Javier Leiva Cuadrado
}
