% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_d.R
\name{calculate_d}
\alias{calculate_d}
\title{\eqn{d_s} for Between Subjects with Pooled SD Denominator}
\usage{
calculate_d(
  m1 = NULL,
  m2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  n1 = NULL,
  n2 = NULL,
  t = NULL,
  model = NULL,
  df = NULL,
  x_col = NULL,
  y_col = NULL,
  d = NULL,
  a = 0.05,
  lower = TRUE
)
}
\arguments{
\item{m1}{mean group one}

\item{m2}{mean group two}

\item{sd1}{standard deviation group one}

\item{sd2}{standard deviation group two}

\item{n1}{sample size group one}

\item{n2}{sample size group two}

\item{t}{optional, calculate d from independent t, you must
include n1 and n2 for degrees of freedom}

\item{model}{optional, calculate d from t.test for independent t,
you must still include n1 and n2}

\item{df}{optional dataframe that includes the x_col and y_col}

\item{x_col}{name of the column that contains the factor levels OR
a numeric vector of group 1 scores}

\item{y_col}{name of the column that contains the dependent score OR
a numeric vector of group 2 scores}

\item{d}{a previously calculated d value from a study}

\item{a}{significance level}

\item{lower}{Use this to indicate if you want the lower or upper bound
of d for one sided confidence intervals. If d is positive, you generally
want \code{lower = TRUE}, while negative d values should enter
\code{lower = FALSE} for the upper bound that is closer to zero.}
}
\value{
Provides the effect size (Cohen's *d*) with associated
central and non-central confidence intervals,
the *t*-statistic, the confidence intervals associated with the means of
each group, as well as the standard deviations and standard errors
of the means for each group. The one-tailed confidence interval
is also included for sensitivity analyses.

\item{d}{effect size}
\item{dlow}{noncentral lower level confidence interval of d value}
\item{dhigh}{noncentral upper level confidence interval of d value}
\item{dlow_central}{central lower level confidence interval of d value}
\item{dhigh_central}{central upper level confidence interval of d value}
\item{done_low}{noncentral lower bound of one tailed confidence interval}
\item{done_low_central}{central lower bound of
one tailed confidence interval}
\item{M1}{mean of group one}
\item{sd1}{standard deviation of group one mean}
\item{se1}{standard error of group one mean}
\item{M1low}{lower level confidence interval of group one mean}
\item{M1high}{upper level confidence interval of group one mean}
\item{M2}{mean of group two}
\item{sd2}{standard deviation of group two mean}
\item{se2}{standard error of group two mean}
\item{M2low}{lower level confidence interval of group two mean}
\item{M2high}{upper level confidence interval of group two mean}
\item{spooled}{pooled standard deviation}
\item{sepooled}{pooled standard error}
\item{n1}{sample size of group one}
\item{n2}{sample size of group two}
\item{df}{degrees of freedom (n1 - 1 + n2 - 1)}
\item{t}{t-statistic}
\item{p}{p-value}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays d for two between subjects groups
and gives the central and non-central confidence interval
using the pooled standard deviation as the denominator.
}
\details{
To calculate \eqn{d_s}, mean two is subtracted from mean one and divided
by the pooled standard deviation.
\deqn{d_s = \frac{M_1 - M_2}{S_{pooled}}}

You should provide one combination of the following:

1: m1 through n2

2: t, n1, n2

3: model, n1, n2

4: df, "x_col", "y_col"

5: x_col, y_col as numeric vectors

6: d, n1, n2

You must provide alpha and lower to ensure the right confidence
interval is provided for you.
}
\examples{
calculate_d(m1 = 14.37, # neglect mean
   sd1 = 10.716, # neglect sd
   n1 = 71, # neglect n
   m2 = 10.69, # none mean
   sd2 = 8.219, # none sd
   n2 = 3653, # none n
   a = .05, # alpha/confidence interval
   lower = TRUE) # lower or upper bound

}
\keyword{between-subjects}
\keyword{deviation}
\keyword{effect}
\keyword{independent}
\keyword{pooled}
\keyword{sd}
\keyword{size}
\keyword{standard}
\keyword{t}
