% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.pw_exp.R
\name{r.pw_exp}
\alias{r.pw_exp}
\title{Sample from a piecewise-constant exponential distribution.}
\usage{
r.pw_exp(n, breakpoints, rates)
}
\arguments{
\item{n}{Number of random draws required}

\item{breakpoints}{Breakpoints in piecewise-constant exponential
distribution}

\item{rates}{Piecewise-constant rates}
}
\value{
Vector of waiting times, drawn from piecewise-exponential survival
function.
}
\description{
Takes n random draws from a piecewise-constant exponential distribution.
}
\examples{


breakpoints <- c(0, 10, 20, 30, 60)
rates <- c(0.01,0.02,0.04,0.15)
pw_sample <- r.pw_exp (n=10, breakpoints, rates=rates)


}
\author{
Frans Willekens
}
