% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importVirusTable.R
\name{ImportVirusTable}
\alias{ImportVirusTable}
\title{ImportVirusTable: Import VirusHunterGatherer hittables into R}
\usage{
ImportVirusTable(path)
}
\arguments{
\item{path}{A character string specifying the path to the VirusHunter or VirusGatherer hittable file.}
}
\value{
A data frame containing the data from the VirusHunter or VirusGatherer hittable file.
}
\description{
ImportVirusTable imports VirusHunterGatherer hittables into R.
}
\details{
ImportVirusTable reads the VirusHunter or VirusGatherer hittable file specified by 'path'
into a data frame in R. The file should be in tab-separated values (TSV) format.
The first row should contain column headers.
}
\examples{
path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
vh_file <- ImportVirusTable(path)

print(head(vh_file))

# import gatherer files
path2 <- system.file("extdata", "virusgatherer.tsv", package = "Virusparies")
vg_file <- ImportVirusTable(path2)

print(head(vg_file))

}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
