\name{panelSelectMultiple}
\alias{panelSelectMultiple}
\title{Selecting panels from several distributions}
\description{
To draw the selected panels from several distributions generated by \code{VisCov}.
}
\usage{
panelSelectMultiple(selected.condition, CovPlotDataMultiple, range.logical.contour = FALSE, 
                    range.logical.all = TRUE, row = FALSE)
}
\arguments{
\item{selected.condition}{a vector of strings containing types of the panels that one wishes to select:
For layer 1, "vari", "cor";
for layer 2, "scatter1", "scatter2", "scatter3", "scatter4", "scatter5";
for layer 3, "contour", "threeD";
for layer 4, "Effective.Variance", "Effective.Dependence", "Effective.Dependence.submatrix"}
\item{CovPlotDataMultiple}{a list of objects returned by \code{VisCov}}
\item{range.logical.all}{a logical value indicating whether the ranges in the panels are set as the same over
different sets of samples. For the histograms, the ranges of frequencies are
set as the same over the different sets of samples}
\item{range.logical.contour}{a logical value indicating whether the ranges of the contour plots are set as the same
over different sets of samples when \code{range.logical.all} is TRUE}
\item{row}{a logical value whether the panels belonging to the same set of samples are arranged in the same
row. If it is FALSE, they are arranged in the same column}
}

\references{
Tokuda, T., Goodrich, B.,  Van Mechelen, I., Gelman, A., & Tuerlinckx, F. (submitted). Visualizing Distributions of Covariance Matrices
}

\examples{
distribution = "Inverse Wishart"
dim = 4
param = list(prob = 0.5, dim = dim, nu = dim+1, scaleCov = diag(1,dim))
CovPlotData1 = VisCov(distribution, param, title.logical = FALSE)
distribution = "Inverse Wishart"
dim = 4
param = list(prob = 0.5, dim = dim, nu = dim+50, scaleCov = diag(1,dim))
CovPlotData2 = VisCov(distribution, param, title.logical = FALSE)
selected.condition = c("scatter1", "scatter4", "contour", "Effective.Dependence")
panelSelectMultiple(selected.condition, list(CovPlotData1, CovPlotData2))
}


