% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{new_visitation_forecast}
\alias{new_visitation_forecast}
\title{visitation_forecast Class}
\usage{
new_visitation_forecast(
  forecasts,
  logged_forecasts,
  differenced_logged_forecasts,
  differenced_standard_forecasts,
  n_ahead,
  proxy_forecasts,
  onsite_usage_forecasts,
  beta,
  constant,
  slope,
  criterion,
  past_observations,
  lag_estimate
)
}
\arguments{
\item{forecasts}{A time series of forecasts for the visitation model. the forecasts will be in the standard scale of visitors per month}

\item{logged_forecasts}{A time series of the logged forecasts for the visitation model.}

\item{differenced_logged_forecasts}{A time series of the differenced logged forecasts  for the visitation model.}

\item{differenced_standard_forecasts}{A time series of the exponentiated differenced logged forecasts that are for the visitation model.}

\item{n_ahead}{An integer describing the number of forecasts made.}

\item{proxy_forecasts}{A time series of forecasts of the popularity proxy series.}

\item{onsite_usage_forecasts}{A time series of forecasts of the original time series.}

\item{beta}{A numeric or a character string specifying the seasonality adjustment factor. (beta_1)}

\item{constant}{A numeric specifying the constant term in the model. This constant is understood as the mean of the trend-adjusted time_series. (beta_0)}

\item{slope}{A numeric specifying the slope term in the model when a linear trend is assumed. (beta_2)}

\item{criterion}{One of "MSE" or "Nonparametric", to specify the criterion used to select the lag.}

\item{past_observations}{One of "none", "fitted", or "ref_series". If "fitted", past model fitted values are used. If "ref_series", the reference series in the visitation model object is used. Note that if difference = TRUE, one of these is needed to forecast the first difference.}

\item{lag_estimate}{A numeric value specifying the estimated lag in the visitation model.}
}
\value{
Object of class "labeled_visitation_forecast".

Object of class "Visitation_forecast".
}
\description{
Class for visitation_model predictions (for use with predict.visitation_model()).
}
