% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simon_pr.R
\docType{class}
\name{Simon_pr}
\alias{Simon_pr}
\alias{Simon_pr-class}
\title{\linkS4class{Simon_pr}: Probabilities of a Simon's Two-Stage Design}
\usage{
Simon_pr(prob, n1, n, r1, r)
}
\arguments{
\item{prob}{\link[base]{double} \link[base]{vector}, true response rate(s) \eqn{p}}

\item{n1, n}{positive \link[base]{integer} scalars, Stage-1 sample size \eqn{n_1} and total sample size \eqn{n}}

\item{r1, r}{non-negative \link[base]{integer} scalars, number of response
in Stage-1 \eqn{r_1} and overall \eqn{r} required \emph{exclusively},
i.e., passing Stage-1 indicates observing \eqn{>r_1} responses,
and rejecting \eqn{H_0} indicates observing \eqn{>r} responses.}
}
\value{
\link{Simon_pr} returns \linkS4class{Simon_pr} object.
}
\description{
Probability of frail
(i.e., early termination), fail (to reject the null) and success (to reject the null)
of a Simon's two-stage design, at given true response rate(s).
}
\details{
Given the Simon's two-stage design \eqn{(n_1, r_1, n, r)}, for a response rate
\eqn{p}, we have the number of Stage-1 positive responses \eqn{X_1 \sim \textrm{Binom}(n_1, p)}
and the number of Stage-2 positive responses \eqn{X_2 \sim \textrm{Binom}(n-n_1, p)}.
Obviously \eqn{X_1} and \eqn{X_2} are independent.

The probability of early termination is \eqn{\textrm{Pr}(X_1 \leq r_1)}.

The probability of failure to reject \eqn{H_0} is
\deqn{\sum_{s_1 = r_1+1}^{n_1} \textrm{Pr}(X_1=s_1)\cdot\textrm{Pr}(X_2 \leq (r-s_1))}

The probability of rejecting \eqn{H_0} is
\deqn{\sum_{s_1 = r_1+1}^{n_1} \textrm{Pr}(X_1=s_1)\cdot\textrm{Pr}(X_2 > (r-s_1))}

Parameters nomenclature of \code{n1}, \code{n}, \code{r1} and \code{r} follows that of
PASS and function \link[clinfun]{ph2simon}.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\link[base]{ncol}-3 \link[base]{double} \link[base]{matrix}, probability of frail
(i.e., early termination), fail (to reject the null) and success (to reject the null), at each
response rate \eqn{p} given in \verb{@prob}}

\item{\code{eN}}{\link[base]{numeric} \link[base]{vector}, expected sample size(s) \eqn{\textrm{E}(N)} for each of response rate(s) \eqn{p}}

\item{\code{prob}}{\link[base]{double} \link[base]{vector}, response rate(s) \eqn{p}}
}}

\examples{
Simon_pr(prob = c(.2, .4), n1 = 15L, r1 = 3L, n = 24L, r = 7L)

}
