% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{shrub.data}
\alias{shrub.data}
\title{Shrub data}
\format{
A \code{data.frame} with the following variables:
\tabular{ll}{
\code{Replica} \tab {Replica identifier (I or II).} \cr \tab \cr
\code{Transect} \tab {Transect identifier (1,2 or 3).} \cr \tab \cr
\code{Number} \tab {Shrub/clump identifier.} \cr \tab \cr
\code{Intercept} \tab {Length of the intersection of the clump of overlapping shrubs with the transect.} \cr \tab \cr
\code{Width} \tab {Width between two lines tangent to the shrub and parallel to the transect. } \cr \tab \cr
\code{Height} \tab {Maximum height of the shrub encountered by the transect.} \cr \tab \cr
\code{Stems} \tab {Number of stems on the shrub encountered by the transect.} \cr
}
}
\source{
\url{https://www.proquest.com/docview/303721613?\%20T&fromopenview=true&pq-origsite=gscholar&sourcetype=Dissertations\%20}
}
\usage{
data(shrub.data)
}
\description{
Dataset containing the size of the \emph{Cercocarpus montanus} species in an ancient quarry.
}
\details{
During the fall semester of 1986, students in a graduate course on biological sampling techniques, taught by Lyman L. McDonald at the University of Wyoming, conducted a field study using the linear transect method to measure the size of Cercocarpus montanus shrubs in an old limestone quarry located just east of Laramie, Wyoming. In this area, rock fissures run predominantly north to south, and vegetation is denser within them. To align with this structure, a baseline was established approximately parallel to the fissures, and six transects were placed perpendicular to this baseline, grouped into two independent replicates (I and II), each comprising three equally spaced transects.

Students walked along the transects and recorded all Cercocarpus montanus individuals intersected. For each shrub, they measured maximum height, width (defined as the greatest distance between two tangents to the shrub’s contour, parallel to the transect), and the number of stems. Given the rhizomatous nature of the species and possible interconnections between neighboring shrubs, an individual was defined as a group of stems at the base separated by at least fifteen centimeters from the nearest neighbor. Additionally, the length of intersection with the transect line was recorded for each shrub cluster.

Due to the nature of the sampling method, wider shrubs had a higher probability of being intersected by a transect. As a result, the sample of shrub widths exhibits length bias. Measurements of height and number of stems are also affected by sampling bias, although the associated bias function is more complex, as it depends on the relationship between width and these other morphological features.

For further details on the sampling protocol and data structure, see \insertCite{muttlak1988;textual}{WData}.
}
\examples{
data(shrub.data)
names(shrub.data)
str(shrub.data)
class(shrub.data)
}
\references{
\insertAllCited{}
}
\keyword{datasets}
