% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_amplification_efficiency.R
\name{est_amplification_efficiency}
\alias{est_amplification_efficiency}
\title{Estimate PCR amplification efficiency}
\usage{
est_amplification_efficiency(n_copies, ct_value)
}
\arguments{
\item{n_copies}{A numeric vector giving the serial diluted concentration of target nucleic acid}

\item{ct_value}{A numeric vector giving the measured Ct value for each serial dilution in the standard curve design}
}
\value{
List containing the mean, and low and high of the 95\% confidence interval for the percentile amplification efficiency.
}
\description{
This function takes a set of serial diluted concentrations of target nucleic acid from a standard curve assay and their associated Ct values and
estimates the percentile amplification efficiency using a linear model as described in \href{https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-7-85}{Yuan et al. (2008)}.
Note that the model uses a log base 2 transform which assumes that serial dilutions double with each increase in concentration. The function also
requires a minimum of 5 observations.
}
\examples{

sel <- template_WES_standard_curve$target_name == 'target_1'
tmp_n_copies <- template_WES_standard_curve$n_copies[sel]
tmp_ct_value <- template_WES_standard_curve$ct_value[sel]

est_amplification_efficiency(n_copies = tmp_n_copies,
                             ct_value = tmp_ct_value)

}
