% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_esi_data.R
\name{get_esi_data}
\alias{get_esi_data}
\title{Get Evaporative Stress Index (ESI) data}
\usage{
get_esi_data(lon, lat, dates, intervals = NULL)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}

\item{dates}{A character or date vector of dates giving the date when each sample was
collected (format is YYYY-MM-DD)}

\item{intervals}{An integer vector giving a set of time intervals over which to calculate
the average ESI. Default is NULL where the interval is 0 (returns the ESI value at time t). If \code{intervals}=3
then the average ESI over the preceding 3 days is returned.}
}
\value{
data.frame
}
\description{
This function takes information of where and when a set of environmental samples were
collected and retrieves the Evaporative Stress Index (ESI) for those locations and times.
For more information about ESI, see description \href{https://climateserv.readthedocs.io/en/latest/user/datasets.html#evaporative-stress-index-esi}{HERE}.
Data come from the Climate Hazards Center InfraRed Precipitation with Station data (\href{https://www.chc.ucsb.edu/data}{CHIRPS}) via
the \href{https://docs.ropensci.org/chirps/}{\code{chirps}} R package. Additionally, the optional \code{intervals} argument
specifies a set of intervals over which the function will calculate the average ESI for the previous X number
of days for each location.
}
\examples{
\donttest{

tmp <- get_esi_data(lon = c(-54.9857, -52.9857),
                    lat = c(-5.9094, -25.8756),
                    dates = c("2020-06-01", "2020-10-31"),
                    intervals = c(5,10,20))

head(tmp)

}
}
