% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{CoxSnell_bias}
\alias{CoxSnell_bias}
\alias{CoxSnell_bias_log}
\title{Cox & Snell bias correction methods for estimators}
\usage{
CoxSnell_bias(n, lambda, phi)

CoxSnell_bias_log(n, lambda, phi)
}
\arguments{
\item{n}{a numeric value of data length.}

\item{lambda}{a numeric value of estimated lambda.}

\item{phi}{a numeric value of estimated phi.}
}
\value{
A numeric vector of Cox & Snell biases of lambda and phi.
}
\description{
\code{CoxSnell_bias} and \code{CoxSnell_bias_log} provide a vector of MLE bias, and it can be used for
bias correction of both MLE and MLEc. The estimation method was suggested by by Cox and Snell(1968).
}
\details{
\code{CoxSnell_bias} provides the bias of original lambda and phi.
However, \code{CoxSnell_bias_log} provides the bias of log lambda and log phi.
In some cases, estimators are smaller than bias, and it means that the bias corrected estimators
are out of parameter space. To solve this problem, \code{CoxSnell_bias_log} is useful.
Correction formula is based on Fisher information and some cumulants,
which are given in Kim and Jang (2020).
}
\section{Background}{

These functions implement formulas given in Hyoung-Moon Kim. et al. (2020).
}

\examples{
data <- fail_fiber
mlec <- MLEc_WL(data)
n <- length(data)
CoxSnell_bias(n, mlec[1], mlec[2])
CoxSnell_bias_log(n, mlec[1], mlec[2])

}
\references{
Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.
}
