% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{MLE_WL}
\alias{MLE_WL}
\title{MLE in weighed Lindley distribution}
\usage{
MLE_WL(y, init)
}
\arguments{
\item{y}{a numeric vector of observations.}

\item{init}{a initial value for estimate phi.}
}
\value{
A numeric vector of MLE for lambda and phi.
}
\description{
\code{MLE_WL} returns maximum likelihood estimates of parameters.
First, the estimate of phi is obtained from one dimensional non linear equation.
Then, by plugging in the estimated phi, the estimate of lambda is easily obtained.
}
\details{
These functions implement formulas given in Hyoung-Moon Kim. et al. (2020).
}
\examples{
data <- fail_fiber
mme <- MME_WL(data)
modified_mme <- MMEm_WL(data)
mle <- MLE_WL(data, mme[2])
mlec <- MLEc_WL(data)

rbind(mme, modified_mme, mle, mlec)

}
\references{
Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.
}
