% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{MME_WL}
\alias{MME_WL}
\alias{MMEm_WL}
\alias{MLEc_WL}
\title{Estimating parameters in weighed Lindley distribution}
\usage{
MME_WL(x)

MMEm_WL(x)

MLEc_WL(x)
}
\arguments{
\item{x}{a numeric vector.}
}
\value{
A numeric vector of lambda and phi estimated by each method.
}
\description{
Parameter estimate functions: \code{MME_WL}, \code{MMEm_WL}, \code{MLE_WL} and \code{MLEc_WL} can be
used to estimate parameters in weighed Lindley distribution. \code{MME_WL}, \code{MMEm_WL}
and \code{MLEc_WL} have closed form values for parameters, lambda and phi. On the other hands,
parameter lambda in \code{MLE_WL} is
based on numerical solution. It use the function \code{nleqslv} for solving one variable equation.
}
\details{
These functions implement formulas given in Hyoung-Moon Kim. et al. (2020).
}
\examples{
data <- fail_fiber
mme <- MME_WL(data)
modified_mme <- MMEm_WL(data)
mle <- MLE_WL(data, mme[2])
mlec <- MLEc_WL(data)

rbind(mme, modified_mme, mle, mlec)

}
\references{
Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.
}
