% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrtdsperf.R
\name{wrtdsperf}
\alias{wrtdsperf}
\alias{wrtdsperf.tidal}
\alias{wrtdsperf.tidalmean}
\title{Get WRTDS performance metrics}
\usage{
wrtdsperf(dat_in, ...)

\method{wrtdsperf}{tidal}(dat_in, logspace = TRUE, ...)

\method{wrtdsperf}{tidalmean}(dat_in, logspace = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal object which must already have fitted model data}

\item{...}{arguments passed to or from other methods}

\item{logspace}{logical if performance metrics use back-transformed residuals}
}
\value{
A \code{\link[base]{data.frame}} with the metrics for each quantile model
}
\description{
Get WRTDS performance metrics including goodness of fit, root mean square error, and normalized mean square error.
}
\details{
Goodness of fit is calculated using the \code{\link{goodfit}} function for quantile regression described in Koenker and Mochado 1999.  Root mean square error is based on square root of the mean of the squared residuals.  Normalized mean square error described in Gershenfeld and Weigend 1993 is the sum of the squared errors divided by the sum of the non-conditional errors (i.e., sum of the squared values of the observed minus the mean of the observed).  This measure allows comparability of error values for data with different ranges, although the interpretation for quantile models is not clear.  The value is provided as a means of comparison for WRTDS models created from the same data set but with different window widths during model fitting.

Performance metrics are only valid for observations and model residuals in log-space.  Metrics also only apply to the data used to fit the model, i.e., performance will not be evaluated for novel data if the \code{dat_pred} argument was used with  \code{\link{respred}}.
}
\examples{
## load a fitted model object
data(tidfit)

## get performance metrics
wrtdsperf(tidfit)
}
\references{
Gershenfeld, N.A., Weigend, A.S. 1993. The future of time series: learning and understanding. In: Weigend, A.S., Gershenfeld, N.A. (eds). Time Series Prediction: Forecasting the Future and Understanding the Past., second ed. Addison-Wesley, Santa Fe, New Mexico. pp. 1-70.

Koenker, R., Machado, J.A.F. 1999. Goodness of fit and related inference processes for quantile regression. Journal of the American Statistical Association. 94(448):1296-1310.
}
\seealso{
\code{\link{wrtdsrsd}} for residuals, \code{\link{goodfit}}
}
