% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_geodesic.R
\name{geodesic_pos}
\alias{geodesic_pos}
\title{Compute Wasserstein geodesics}
\usage{
geodesic_pos(P1, P2, p = 2, steps)
}
\arguments{
\item{P1}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{P2}{One of the following: A matrix, representing an image;
A file name containing an image; A \link[transport]{wpp-object}.}

\item{p}{A real number >=1 specifying the exponent of the Wasserstein distance.}

\item{steps}{A vector of numbers in [0,1] describing the time points at which the geodesic should be evaluated.}
}
\value{
A list of the same length as steps where each element is a \link[transport]{wpp-object} describing the value of the geodesic at the 
corresponding times in steps.
}
\description{
Computes the geodesic between two measures P1 and P2 in arbitrary dimensions at given timepoints.
}
\examples{
U<-runif(20)
U<-U/sum(U)
pos<-matrix(runif(2*20),nrow=20,ncol=2)
P1<-transport::wpp(pos,U)
U<-runif(20)
U<-U/sum(U)
pos<-matrix(runif(2*20),nrow=20,ncol=2)
P2<-transport::wpp(pos,U)
geodesic<-geodesic_pos(P1,P2,p=2,seq(0,1,0.1))
## Set the image and/or gif flags to TRUE to run the example. 
## CRAN policy prevents examples from generating files in the working directory,
## so this had to be disabled.
plotGeodesic(geodesic,File="GeodesicR2",images=FALSE,gif=FALSE)
}
