% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HexBinPlot.R
\name{HexBinPlot}
\alias{HexBinPlot}
\title{Build a hex bin plot}
\usage{
HexBinPlot(d, xvar, yvar, title, ..., bins = 30, binwidth = NULL,
  na.rm = FALSE)
}
\arguments{
\item{d}{data frame}

\item{xvar}{name of x variable column}

\item{yvar}{name of y variable column}

\item{title}{plot title}

\item{...}{not used, forces later arguments to bind by name}

\item{bins}{passed to geom_hex}

\item{binwidth}{passed to geom_hex}

\item{na.rm}{passed to geom_hex}
}
\value{
a ggplot2 hexbin plot
}
\description{
Build a hex bin plot with rational color coding.
}
\details{
Builds a standard ggplot2 hexbin plot,
with a color scale such that dense areas are colored darker (the default
ggplot2 fill scales will color dense areas lighter).

Requires the \code{hexbin} package.
}
\examples{

if(requireNamespace("hexbin", quietly = TRUE)) {
   set.seed(634267)
   dframe = data.frame(x = rnorm(1000), y = rnorm(1000))
   print(HexBinPlot(dframe, "x", "y", "Example hexbin"))

   diamonds = ggplot2::diamonds
   print(HexBinPlot(diamonds, "carat", "price", "Diamonds example"))
}

}
\seealso{
\code{\link[ggplot2]{geom_hex}}
}
