% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model14.R
\name{wp.modmed.m14}
\alias{wp.modmed.m14}
\title{model14}
\usage{
wp.modmed.m14(
  a1 = 0.2,
  cp = 0.2,
  b1 = 0.5,
  d1 = 0.5,
  b2 = 0.2,
  sigx2 = 1,
  sigw2 = 1,
  sige12 = 1,
  sige22 = 1,
  sigx_w = 0.5,
  n = 100,
  nrep = 100,
  alpha = 0.05,
  b = 1000,
  nb = n,
  w_value = 0,
  method = "value",
  ncore = 1,
  pop.cov = NULL,
  mu = NULL,
  varnames = c("y", "x", "w", "m", "mw")
)
}
\arguments{
\item{a1}{regression coefficient of mediator (m) on predictor (x)}

\item{cp}{regression coefficient of outcome (y) on predictor (x)}

\item{b1}{regression coefficient of outcome (y) on mediator (m)}

\item{d1}{regression coefficient of outcome (y) on moderator (w)}

\item{b2}{regression coefficient of outcome (y) on the product (mw)}

\item{sigx2}{variance of predictor (x)}

\item{sigw2}{variance of moderator (w)}

\item{sige12}{variance of error in the first regression equation}

\item{sige22}{variance of error in the second regression equation}

\item{sigx_w}{covariance between predictor (x) and moderator (w)}

\item{n}{sample size}

\item{nrep}{number of replications}

\item{alpha}{type 1 error rate}

\item{b}{number of bootstrap iterations}

\item{nb}{bootstrap sample size, default to n}

\item{w_value}{moderator level}

\item{method}{"value" for using the indirect effect value in power calculation, or "joint" for using joint significance in power calculation}

\item{ncore}{number of cores to use, default is 1, when ncore > 1, parallel is used}

\item{pop.cov}{covariance matrix, default to NULL if using the regression coefficient approach}

\item{mu}{mean vector, default to NULL if using the regression coefficient approach}

\item{varnames}{name of variables for the covariance matrix}
}
\value{
power of indirect effect, direct effect, and moderation
}
\description{
power analysis of model 14 in Introduction to Mediation, Moderation, and Conditional Process Analysis
}
\examples{
\donttest{
test = wp.modmed.m14(a1 = 0.2, cp = 0.2, b1 = 0.5, d1 = 0.5, b2 = 0.2, sigx2 = 1,
                    sigw2 = 1, sige12 = 1, sige22 = 1, sigx_w = 0.5, n = 50,
                    nrep = 100, alpha = 0.05, b = 1000, ncore = 1)
print(test)
}
}
