% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.last.mode}
\alias{get.last.mode}
\title{Get Last Peak}
\usage{
get.last.mode(x, y, rare.prop = 1/5, verbose = TRUE, remove.tail = TRUE,
  ...)
}
\arguments{
\item{x}{values of midpoints from \code{\link{hist}}}

\item{y}{values of counts from \code{\link{hist}}}

\item{rare.prop}{Proportion used to remove rare intensity tail}

\item{verbose}{print diagnostic output}

\item{remove.tail}{Remove rare intensity tail}

\item{...}{arguments to be passed to \code{\link{smooth_hist}}}
}
\value{
Value of x that is the last peak
}
\description{
This function grabs the last peak or shoulder.
}
\examples{
data(t1.voi.hist)
system.time({
y = t1.voi.hist$counts
x = t1.voi.hist$mids
x = x[!is.na(y)];
y = y[!is.na(y)]
# 20 used for speed of example
nawm_peak = get.last.mode(x, y, k=20)
plot(t1.voi.hist, border="red")
abline(v=nawm_peak)
})
}

