% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{corpus_contrib_data}
\alias{corpus_contrib_data}
\title{Adding data to a contributor corpus}
\usage{
corpus_contrib_data(method, x, prefix = "Utilisateur", domain = "fr")
}
\arguments{
\item{method}{The method employed to get data into the corpus. \describe{
 \item{raw}{For each user, downloading caracteristics and testing other member of the corpus.}
 \item{page}{For each user, downloading edited pages.}
}}

\item{x}{The users' corpus.}

\item{prefix}{In the wiki, the prefix for users' pages namespace.}

\item{domain}{The domain where the wiki is located.}
}
\value{
A data-frame.
}
\description{
Adding data to a contributor corpus
}
\examples{
c <- corpus_contrib_create('page','Action',limit=5)
\donttest{
 c <- corpus_contrib_data('raw',c)
}
}
\seealso{
Other corpus functions: \code{\link{corpus_contrib_create}},
  \code{\link{corpus_contrib_select}},
  \code{\link{corpus_page_create}},
  \code{\link{corpus_page_data}}
}

