% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query_wikidata}
\alias{query_wikidata}
\title{Send one or more SPARQL queries to WDQS}
\usage{
query_wikidata(sparql_query, format = c("simple", "smart"), ...)
}
\arguments{
\item{sparql_query}{SPARQL query (can be a vector of queries)}

\item{format}{"simple" uses CSV and returns pure character data frame, while
"smart" fetches JSON-formatted data and returns a data frame with datetime
columns converted to \code{POSIXlt}}

\item{...}{Additional parameters to supply to \code{\link[httr:GET]{httr::GET()}}}
}
\value{
A \code{data.frame}
}
\description{
Makes a GET request to Wikidata Query Service SPARQL endpoint.
}
\examples{
# R's versions and release dates:
sparql_query <- 'SELECT DISTINCT
  ?softwareVersion ?publicationDate
WHERE {
  BIND(wd:Q206904 AS ?R)
  ?R p:P348 [
    ps:P348 ?softwareVersion;
    pq:P577 ?publicationDate
  ] .
}'
query_wikidata(sparql_query)

\dontrun{
# "smart" format converts all datetime columns to POSIXlt
query_wikidata(sparql_query, format = "smart")
}
}
