% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPsimulatedAnnealing.R
\name{WPSA}
\alias{WPSA}
\title{p-Wasserstein distance projections using simulated annealing}
\usage{
WPSA(
  X,
  Y = NULL,
  theta,
  power = 2,
  force = NULL,
  model.size = 3,
  nvars = NULL,
  maxit = 1,
  temps = 1000,
  max.time = 3600,
  const = NULL,
  proposal = proposal.fun,
  options = list(method = c("selection.variable", "scale", "projection"),
    transport.method = transport_options(), energy.distribution = "boltzman",
    cooling.schedule = "Geman-Geman", proposal.method = "covariance", epsilon = 0.05,
    OTmaxit = 100),
  display.progress = FALSE,
  parallel = NULL,
  calc.theta = TRUE,
  xtx = NULL,
  xty = NULL,
  ...
)
}
\arguments{
\item{X}{Covariate vector}

\item{Y}{Predictions}

\item{theta}{Optional matrix of parameters for generating predictions}

\item{power}{Power of the Wasserstein distance}

\item{force}{Any covariates to force into the model?}

\item{model.size}{Maximum number of coefficients}

\item{nvars}{The number of variables to explore. Should be an integer vector of model sizes. Default is NULL which will explore all models from 1 to \code{model.size}.}

\item{maxit}{Maximum number of iterations}

\item{temps}{Number of temperatures}

\item{max.time}{Maximum time in seconds to run}

\item{const}{Maximum value for simulated annealing distance}

\item{proposal}{Proposal function. There is a default method but can provide your own with parameters \code{xty}, \code{cur}, \code{idx}, \code{force}, \code{d}, \code{method}}

\item{options}{Options for simulated annealing}

\item{display.progress}{Whether to display solver progress. TRUE or FALSE. Default is FALSE.}

\item{parallel}{A \code{\link[foreach:foreach]{foreach::foreach()}} backend}

\item{calc.theta}{Should the model save the linear coefficients? TRUE or FALSE. Default is TRUE}

\item{xtx}{precomputed crossproduct \code{crossprod(X,X)}}

\item{xty}{precomputed \code{crossprod(X, Y)}}
}
\value{
An object of class \code{WpProj}
}
\description{
p-Wasserstein distance projections using simulated annealing
}
\keyword{internal}
