% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{binary_program_method_options}
\alias{binary_program_method_options}
\title{Options For Use With the Binary Program Method}
\usage{
binary_program_method_options(
  maxit = 500L,
  infimum.maxit = 100L,
  transport.method = transport_options(),
  epsilon = 0.05,
  OTmaxit = 100L,
  model.size = NULL,
  nvars = NULL,
  tol = 1e-07,
  display.progress = FALSE,
  parallel = NULL,
  solver.options = NULL
)
}
\arguments{
\item{maxit}{The maximum iterations for the optimizer. Default is 500.}

\item{infimum.maxit}{Maximum iterations to alternate binary program and Wasserstein distance calculations}

\item{transport.method}{Method for Wasserstein distance calculation. Should be one the outputs of \code{\link[=transport_options]{transport_options()}}}

\item{epsilon}{A value > 0 for the penalty parameter of if using the Sinkhorn method}

\item{OTmaxit}{The number of iterations to run the Wasserstein distance solvers.}

\item{model.size}{What is the maximum number of coefficients to have in the final model. Default is NULL. If NULL, will find models from the minimum size, 0, to the number of columns in \code{X}.}

\item{nvars}{The number of variables to explore. Should be an integer vector of model sizes. Default is NULL which will explore all models from 1 to \code{model.size}.}

\item{tol}{The tolerance for convergence}

\item{display.progress}{Logical. Should intermediate progress be displayed? TRUE or FALSE. Default is FALSE.}

\item{parallel}{A cluster backend to be used by \code{\link[foreach:foreach]{foreach::foreach()}}. See \code{\link[foreach:foreach]{foreach::foreach()}} for details about how to set them up. The \code{WpProj} functions will register the cluster with the \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}} function internally.}

\item{solver.options}{Options to be passed on to the solver. See details}
}
\value{
A list with names corresponding to each argument above.
}
\description{
Options For Use With the Binary Program Method
}
\details{
This function will setup the default arguments used by the binary program method. Of note, for the argument \code{solver.options}, If using the "lasso" solver, you should provide arguments such as "penalty", "nlambda", "lambda.min.ratio", "gamma", and "lambda" in a list. A simple way to do this is to feed the output of the \code{\link[=L1_method_options]{L1_method_options()}} function to the argument \code{solver.options.} This will tell the approximate solver, which uses a lasso method that then will project the parameters back to the \eqn{\{0,1\}} space. For the other solvers, you can see the options in the ECOS solver package, \code{\link[ECOSolveR:ecos.control]{ECOSolveR::ecos.control()}}, and the options for the mosek solver, \code{\link[Rmosek:mosek]{Rmosek::mosek()}}.
}
\examples{
binary_program_method_options()
# is using the lasso solver for the binary program method to give an approximate solution
binary_program_method_options(solver.options = L1_method_options(nlambda = 50L))
}
\seealso{
\code{\link[=WpProj]{WpProj()}}
}
