% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgePlot.R
\name{ridgePlot}
\alias{ridgePlot}
\title{Ridge Plots for a Range of Coefficients}
\usage{
ridgePlot(
  fit,
  index = 1,
  minCoef = 1,
  maxCoef = 10,
  scale = 1,
  alpha = 0.5,
  full = NULL,
  transform = function(x) {
     x
 },
  xlab = "Predictions",
  bandwidth = NULL
)
}
\arguments{
\item{fit}{A \code{WpProj} object or list of \code{WpProj} objects}

\item{index}{The observation number to select. Can be a vector}

\item{minCoef}{The minimum number of coefficients to use}

\item{maxCoef}{The maximum number of coefficients to use}

\item{scale}{How the densities should be scale}

\item{alpha}{Alpha term from ggplot2 object}

\item{full}{"True" prediction to compare to}

\item{transform}{transform for predictions}

\item{xlab}{x-axis label}

\item{bandwidth}{Bandwidth for kernel}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot
}
\description{
Ridge Plots for a Range of Coefficients
}
\examples{
if(rlang::is_installed("stats")) {
n <- 128
p <- 10
s <- 99
x <- matrix(stats::rnorm(n*p), nrow = n, ncol = p )
beta <- (1:10)/10
y <- x \%*\% beta + stats::rnorm(n)
post_beta <- matrix(beta, nrow=p, ncol=s) + matrix(stats::rnorm(p*s, 0, 0.1), p, s)
post_mu <- x \%*\% post_beta
fit <-  WpProj(X=x, eta=post_mu, 
             power = 2
)
ridgePlot(fit)
}
}
