% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRtrack.r
\name{xGRtrack}
\alias{xGRtrack}
\title{Function to visualise genes within a genomic region using track plot}
\usage{
xGRtrack(cse.query = NULL, gene.query = NULL, window = 1e+05,
nearby = NULL, name.scoretrack = "Genomic scores",
gene.model = c("UCSC_knownGene_model", "UCSC_knownCanonical_model"),
GR.score = c(NA, "RecombinationRate", "phastCons100way",
"phyloP100way",
"GERP"), GR.score.customised = NULL, name.customised = "Customised",
type.customised = c("point", "line"), label.size = 2,
label.col = "black", label.force = 0.05, verbose = TRUE,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{cse.query}{a genomic region in query. By default it is NULL;
otherwise provided as 'chrN:start-end', where N is either 1-22 or X,
start (or end) is genomic positional number; for example, 'chr1:13-20'.
If provided, it will overwrite the parameter 'gene.query' below}

\item{gene.query}{which gene in query will be visualised. By default it
is NULL}

\item{window}{the maximum distance defining nearby genes around the
gene in query. By default it is 1e5}

\item{nearby}{the maximum number defining nearby genes around the gene
in query. By default it is NULL. If not NULL, it will overwrite the
parameter 'window' above}

\item{name.scoretrack}{the name for the score track. By default, it is
"Genomic scores"}

\item{gene.model}{the genomic regions of the gene model. By default, it
is 'UCSC_knownGene_model', that is, UCSC known genes (together with
genomic locations) based on human genome assembly hg19. It can be
'UCSC_knownCanonical_model', that is, UCSC known canonical genes
(together with genomic locations) based on human genome assembly hg19.
Alternatively, the user can specify the customised input. To do so,
first save your RData file (containing an GR object) into your local
computer, and make sure the GR object content names refer to Gene
Symbols. Then, tell "GR.Gene" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location"}

\item{GR.score}{the genomic regions together with score data. By
default, it is 'NA' to disable this option. Pre-built genomic score
data: 'RecombinationRate' (recombintion rate,
\url{http://www.ncbi.nlm.nih.gov/pubmed/17943122})), 'phastCons100way',
'phyloP100way', 'GERP'.}

\item{GR.score.customised}{the customised genomic score data. By
default, it is NA to disable this option; otherwise load your
customised GR object directly (with the first meta column for scores;
if not provided, it will be valued at 1). If provided, it will be
appended to 'GR.score' above. Also supported is the labelling by
providing a meta-column called 'Label'. It can be also a list of GR
objects}

\item{name.customised}{the name for customised genomic score data. By
default, it is "Customised"}

\item{type.customised}{how to plot customised genomic score data. It
can be "point" or "line"}

\item{label.size}{label size}

\item{label.col}{label color}

\item{label.force}{the repelling force between overlapping labels}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a Tracks object.
}
\description{
\code{xGRtrack} is supposed to visualise genes within a genomic region
using track plot. Genes in query within a genomic region are displayed
on the gene model track along with nearby genes of desired window or
number. If scores for genomic region are also provided, the genomic
score track will be also displayed at the top.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
## given a query gene
tks <- xGRtrack(gene.query='TNF', nearby=10,
gene.model="UCSC_knownGene_model",
GR.score=c("RecombinationRate","phastCons100way"),
RData.location=RData.location)
tks
## given a query genomic region
tks <- xGRtrack(cse.query='chr6:31497996-31584798',
gene.model="UCSC_knownGene_model",
GR.score=c("RecombinationRate","phastCons100way"),
RData.location=RData.location)

### GWAS catalog
GWAScatalog <- xRDataLoader('GWAScatalog',
RData.location=RData.location)
gwas <- xGR(GWAScatalog$cse_hg19, format="chr:start-end")
ind <- match(names(gwas), GWAScatalog$cse_hg19)
gwas$pvalue <- -log10(GWAScatalog$pvalue[ind])
tks <- xGRtrack(gene.query='TNF', nearby=10,
gene.model="UCSC_knownGene_model", GR.score="RecombinationRate",
GR.score.customised=gwas, RData.location=RData.location)
tks

##########################
## Advanced use: customised GR.score
##########################
gene.model <- xRDataLoader("UCSC_knownGene_model",
RData.location=RData.location)

### LDblock_GR
gr <- xRDataLoader("LDblock_GR", RData.location=RData.location)
maf <- gr[,'maf']
distance <- gr[,'distance']
cadd <- gr[,'cadd']
### GR.score.customised as a list of GR objects
GR.score.customised <- list(maf=maf, distance=distance, cadd=cadd)
tks <- xGRtrack(gene.query='TNF', window=1e0, gene.model=gene.model,
GR.score=NA, GR.score.customised=GR.score.customised,
type.customised='point', RData.location=RData.location)
tks

### the built-in provided as the customised
customised <-
c("RecombinationRate","phastCons100way","phyloP100way","GERP","dbSNP_GWAS")
GR.score.customised <- lapply(customised, function(x) xRDataLoader(x,
RData.location=RData.location))
tks <- xGRtrack(gene.query='TNF', nearby=10, gene.model=gene.model,
GR.score=NA, GR.score.customised=GR.score.customised,
type.customised='line', RData.location=RData.location)
tks
}
}
\seealso{
\code{\link{xGRoverlap}}
}
