% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSNP2cGenes.r
\name{xSNP2cGenes}
\alias{xSNP2cGenes}
\title{Function to define HiC genes given a list of SNPs}
\usage{
xSNP2cGenes(data, entity = c("SNP", "chr:start-end", "data.frame",
"bed",
"GRanges"), include.HiC = NA, GR.SNP = c("dbSNP_GWAS",
"dbSNP_Common"), cdf.function = c("empirical", "exponential"),
plot = FALSE, verbose = TRUE,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{an input vector containing SNPs. SNPs should be provided as
dbSNP ID (ie starting with rs) or in the format of 'chrN:xxx', where N
is either 1-22 or X, xxx is number; for example, 'chr16:28525386'.
Alternatively, it can be other formats/entities (see the next parameter
'entity')}

\item{entity}{the data entity. By default, it is "SNP". For general
use, it can also be one of "chr:start-end", "data.frame", "bed" or
"GRanges"}

\item{include.HiC}{genes linked to input SNPs are also included. By
default, it is 'NA' to disable this option. Otherwise, those genes
linked to SNPs will be included according to Promoter Capture HiC
(PCHiC) datasets. Pre-built HiC datasets are detailed in
\code{\link{xDefineHIC}}}

\item{GR.SNP}{the genomic regions of SNPs. By default, it is
'dbSNP_GWAS', that is, SNPs from dbSNP (version 146) restricted to GWAS
SNPs and their LD SNPs (hg19). It can be 'dbSNP_Common', that is,
Common SNPs from dbSNP (version 146) plus GWAS SNPs and their LD SNPs
(hg19). Alternatively, the user can specify the customised input. To do
so, first save your RData file (containing an GR object) into your
local computer, and make sure the GR object content names refer to
dbSNP IDs. Then, tell "GR.SNP" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{cdf.function}{a character specifying a Cumulative Distribution
Function (cdf). It can be one of 'exponential' based on exponential
cdf, 'empirical' for empirical cdf}

\item{plot}{logical to indicate whether the histogram plot (plus
density or CDF plot) should be drawn. By default, it sets to false for
no plotting}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a data frame with following columns:
\itemize{
\item{\code{Gene}: SNP-interacting genes caputured by HiC}
\item{\code{SNP}: SNPs}
\item{\code{Sig}: the interaction score (the higher stronger)}
\item{\code{Weight}: the HiC weight}
}
}
\description{
\code{xSNP2cGenes} is supposed to define HiC genes given a list of
SNPs. The HiC weight is calcualted as Cumulative Distribution Function
of HiC interaction scores.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
# a) provide the SNPs with the significance info
data(ImmunoBase)
data <- names(ImmunoBase$AS$variants)

# b) define HiC genes
df_cGenes <- xSNP2cGenes(data, include.HiC="Monocytes",
RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}
}
