/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class DateTimeFormatter {
    private Map<String, org.joda.time.format.DateTimeFormatter> cache = new HashMap<String, org.joda.time.format.DateTimeFormatter>();

    public final Date parse(String string, String string2) {
        return this.getFormatter(string2).parseDateTime(string).toDate();
    }

    public final String format(Date date, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getFormatter(string).printTo(stringBuffer, (ReadableInstant)new DateTime((Object)date));
        return stringBuffer.toString();
    }

    private org.joda.time.format.DateTimeFormatter getFormatter(String string) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        block24: for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && i + 1 < string.length()) {
                char c = string.charAt(++i);
                switch (c) {
                    case '%': {
                        dateTimeFormatterBuilder.appendLiteral("%");
                        continue block24;
                    }
                    case 'a': {
                        dateTimeFormatterBuilder.appendDayOfWeekShortText();
                        continue block24;
                    }
                    case 'A': {
                        dateTimeFormatterBuilder.appendDayOfWeekText();
                        continue block24;
                    }
                    case 'b': {
                        dateTimeFormatterBuilder.appendMonthOfYearShortText();
                        continue block24;
                    }
                    case 'B': {
                        dateTimeFormatterBuilder.appendMonthOfYearText();
                        continue block24;
                    }
                    case 'c': {
                        throw new UnsupportedOperationException("%c not yet implemented");
                    }
                    case 'd': {
                        dateTimeFormatterBuilder.appendDayOfMonth(2);
                        continue block24;
                    }
                    case 'H': {
                        dateTimeFormatterBuilder.appendHourOfDay(2);
                        continue block24;
                    }
                    case 'I': {
                        dateTimeFormatterBuilder.appendHourOfHalfday(2);
                        continue block24;
                    }
                    case 'j': {
                        dateTimeFormatterBuilder.appendDayOfYear(3);
                        continue block24;
                    }
                    case 'm': {
                        dateTimeFormatterBuilder.appendMonthOfYear(2);
                        continue block24;
                    }
                    case 'M': {
                        dateTimeFormatterBuilder.appendMinuteOfHour(2);
                        continue block24;
                    }
                    case 'p': {
                        dateTimeFormatterBuilder.appendHalfdayOfDayText();
                        continue block24;
                    }
                    case 'O': {
                        if (i + 1 >= string.length()) {
                            dateTimeFormatterBuilder.appendLiteral("%O");
                            continue block24;
                        }
                        switch (string.charAt(++i)) {
                            case 'S': {
                                dateTimeFormatterBuilder.appendSecondOfMinute(2);
                                continue block24;
                            }
                            default: {
                                throw new UnsupportedOperationException("%O[dHImMUVwWy] not yet implemented");
                            }
                        }
                    }
                    case 'S': {
                        dateTimeFormatterBuilder.appendSecondOfMinute(2);
                        continue block24;
                    }
                    case 'y': {
                        dateTimeFormatterBuilder.appendTwoDigitYear(1968, true);
                        continue block24;
                    }
                    case 'Y': {
                        dateTimeFormatterBuilder.appendYear(1, 4);
                        continue block24;
                    }
                    case 'z': {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, true, 1, 2);
                        continue block24;
                    }
                    case 'Z': {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        continue block24;
                    }
                    default: {
                        throw new UnsupportedOperationException("%" + c + " not yet implemented");
                    }
                }
            }
            dateTimeFormatterBuilder.appendLiteral(string.substring(i, i + 1));
        }
        org.joda.time.format.DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
        this.cache.put(string, dateTimeFormatter);
        return dateTimeFormatter;
    }
}

