/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public final class DefaultColumnBuilder
extends ColumnBuilder {
    private String[] missingValueStrings;
    private double[] missingValueNumbers;

    /*
     * WARNING - void declaration
     */
    public DefaultColumnBuilder(int nrows, boolean forceConversion, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, Object[] missingValue, String dateTimeFormat) {
        super(nrows, forceConversion, evaluator, onErrorCell, dateTimeFormat);
        void var2_4;
        int i;
        ArrayList<Double> missingNum = new ArrayList<Double>();
        ArrayList<String> missingStr = new ArrayList<String>();
        for (i = 0; i < missingValue.length; ++i) {
            if (missingValue[i] instanceof String) {
                missingStr.add((String)missingValue[i]);
                continue;
            }
            if (!(missingValue[i] instanceof Double)) continue;
            missingNum.add((Double)missingValue[i]);
        }
        this.missingValueStrings = missingStr.toArray(new String[var2_4.size()]);
        this.missingValueNumbers = new double[missingNum.size()];
        for (i = 0; i < missingNum.size(); ++i) {
            this.missingValueNumbers[i] = (Double)missingNum.get(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleCell(Cell c, CellValue cv) {
        void var1_1;
        String msg;
        switch (cv.getCellType()) {
            case 3: {
                this.addMissing();
                return;
            }
            case 4: {
                this.addValue(c, cv, DataType.Boolean);
                return;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    this.addValue(c, cv, DataType.DateTime);
                    return;
                }
                boolean missing = false;
                for (int i = 0; i < this.missingValueNumbers.length; ++i) {
                    if (cv.getNumberValue() != this.missingValueNumbers[i]) continue;
                    missing = true;
                    break;
                }
                if (missing) {
                    this.addMissing();
                    return;
                }
                this.addValue(c, cv, DataType.Numeric);
                return;
            }
            case 1: {
                void var3_4;
                boolean missing = false;
                for (int i = 0; i < this.missingValueStrings.length; ++i) {
                    if (cv.getStringValue() != null && !cv.getStringValue().equals(this.missingValueStrings[i])) continue;
                    missing = true;
                    break;
                }
                if (var3_4 != false) {
                    this.addMissing();
                    return;
                }
                this.addValue(c, cv, DataType.String);
                return;
            }
            case 2: {
                msg = "Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
                return;
            }
            case 5: {
                void var2_2;
                msg = "Error detected in cell " + CellUtils.formatAsString((Cell)msg) + " - " + CellUtils.getErrorMessage(var2_2.getErrorValue());
                this.cellError(msg);
                return;
            }
        }
        msg = "Unexpected cell type detected for cell " + CellUtils.formatAsString((Cell)msg) + "!";
        this.cellError((String)var1_1);
    }
}

