/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ScatterChartData;
import org.apache.poi.ss.usermodel.charts.ScatterChartSerie;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STScatterStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFScatterChartData
implements ScatterChartData {
    private List<Serie> series = new ArrayList<Serie>();

    public Serie addSerie() {
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries);
        this.series.add(newSerie);
        return newSerie;
    }

    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xssfChart = (XSSFChart)chart;
        CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
        CTScatterChart scatterChart = plotArea.addNewScatterChart();
        this.addStyle(scatterChart);
        for (Serie s : this.series) {
            s.addToChart(scatterChart);
        }
        for (ChartAxis ax : axis) {
            scatterChart.addNewAxId().setVal(ax.getId());
        }
    }

    public List<? extends Serie> getSeries() {
        return this.series;
    }

    private void addStyle(CTScatterChart ctScatterChart) {
        CTScatterStyle scatterStyle = ctScatterChart.addNewScatterStyle();
        scatterStyle.setVal(STScatterStyle.LINE_MARKER);
    }

    public static class Serie
    implements ScatterChartSerie {
        private int id;
        private int order;
        private boolean useCache;
        private Sheet xSheet;
        private Sheet ySheet;
        private CellRangeAddress xAddress;
        private CellRangeAddress yAddress;

        public Serie(int id, int order) {
            this.id = id;
            this.order = order;
            this.useCache = false;
        }

        public void setXValues(Sheet sheet, CellRangeAddress address) {
            this.xSheet = sheet;
            this.xAddress = address;
        }

        public void setYValues(Sheet sheet, CellRangeAddress address) {
            this.ySheet = sheet;
            this.yAddress = address;
        }

        public void setUseCache(boolean useCache) {
            this.useCache = useCache;
        }

        protected void addToChart(CTScatterChart ctScatterChart) {
            CTScatterSer scatterSer = ctScatterChart.addNewSer();
            scatterSer.addNewIdx().setVal((long)this.id);
            scatterSer.addNewOrder().setVal((long)this.order);
            CTAxDataSource xVal = scatterSer.addNewXVal();
            CTNumRef numRef = xVal.addNewNumRef();
            numRef.setF(this.xAddress.formatAsString(this.xSheet.getSheetName(), true));
            CTNumDataSource yVal = scatterSer.addNewYVal();
            numRef = yVal.addNewNumRef();
            numRef.setF(this.yAddress.formatAsString(this.ySheet.getSheetName(), true));
        }
    }
}

