/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideLayout;
import org.openxmlformats.schemas.presentationml.x2006.main.SldLayoutDocument;

public class XSLFSlideLayout
extends XSLFSheet {
    private CTSlideLayout _layout;
    private XSLFSlideMaster _master;

    XSLFSlideLayout() {
        this._layout = CTSlideLayout.Factory.newInstance();
    }

    public XSLFSlideLayout(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        SldLayoutDocument doc = SldLayoutDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._layout = doc.getSldLayout();
    }

    public String getName() {
        return this._layout.getCSld().getName();
    }

    @Internal
    public CTSlideLayout getXmlObject() {
        return this._layout;
    }

    protected String getRootElementName() {
        return "sldLayout";
    }

    public XSLFSlideMaster getSlideMaster() {
        if (this._master == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFSlideMaster)) continue;
                this._master = (XSLFSlideMaster)p;
            }
        }
        if (this._master == null) {
            throw new IllegalStateException("SlideMaster was not found for " + this.toString());
        }
        return this._master;
    }

    public XMLSlideShow getSlideShow() {
        return (XMLSlideShow)this.getParent().getParent();
    }
}

