/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.TextAlign;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTextParagraph
implements Iterable<XSLFTextRun> {
    private final CTTextParagraph _p;
    private final List<XSLFTextRun> _runs;
    private final XSLFTextShape _shape;

    XSLFTextParagraph(CTTextParagraph p, XSLFTextShape shape) {
        this._p = p;
        this._runs = new ArrayList<XSLFTextRun>();
        this._shape = shape;
        for (CTRegularTextRun r : this._p.getRList()) {
            this._runs.add(new XSLFTextRun(r, this));
        }
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (CTRegularTextRun r : this._p.getRList()) {
            out.append(r.getT());
        }
        return out.toString();
    }

    @Internal
    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    XSLFTextShape getParentShape() {
        return this._shape;
    }

    public List<XSLFTextRun> getTextRuns() {
        return this._runs;
    }

    @Override
    public Iterator<XSLFTextRun> iterator() {
        return this._runs.iterator();
    }

    public XSLFTextRun addNewTextRun() {
        CTRegularTextRun r = this._p.addNewR();
        r.addNewRPr();
        XSLFTextRun run = new XSLFTextRun(r, this);
        this._runs.add(run);
        return run;
    }

    public void addLineBreak() {
        this._p.addNewBr();
    }

    public TextAlign getTextAlign() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetAlgn()) {
            return TextAlign.LEFT;
        }
        return TextAlign.values()[pr.getAlgn().intValue() - 1];
    }

    public void setTextAlign(TextAlign align) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (align == null) {
            if (pr.isSetAlgn()) {
                pr.unsetAlgn();
            }
        } else {
            pr.setAlgn(STTextAlignType.Enum.forInt((int)(align.ordinal() + 1)));
        }
    }

    public void setIndent(double value) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (value == -1.0) {
            if (pr.isSetIndent()) {
                pr.unsetIndent();
            }
        } else {
            pr.setIndent(Units.toEMU(value));
        }
    }

    public double getIndent() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetIndent()) {
            return 0.0;
        }
        return Units.toPoints(pr.getIndent());
    }

    public void setLeftMargin(double value) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        pr.setMarL(Units.toEMU(value));
    }

    public double getLeftMargin() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetMarL()) {
            return 0.0;
        }
        return Units.toPoints(pr.getMarL());
    }

    public void setLineSpacing(double linespacing) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (linespacing >= 0.0) {
            spc.addNewSpcPct().setVal((int)(linespacing * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-linespacing * 100.0));
        }
        pr.setLnSpc(spc);
    }

    public double getLineSpacing() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetLnSpc()) {
            return 100.0;
        }
        CTTextSpacing spc = pr.getLnSpc();
        if (spc.isSetSpcPct()) {
            return (double)spc.getSpcPct().getVal() * 0.001;
        }
        if (spc.isSetSpcPts()) {
            return (double)(-spc.getSpcPts().getVal()) * 0.01;
        }
        return 100.0;
    }

    public void setSpaceBefore(double spaceBefore) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceBefore >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceBefore * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceBefore * 100.0));
        }
        pr.setSpcBef(spc);
    }

    public double getSpaceBefore() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetSpcBef()) {
            return 0.0;
        }
        CTTextSpacing spc = pr.getSpcBef();
        if (spc.isSetSpcPct()) {
            return (double)spc.getSpcPct().getVal() * 0.001;
        }
        if (spc.isSetSpcPts()) {
            return (double)(-spc.getSpcPts().getVal()) * 0.01;
        }
        return 0.0;
    }

    public void setSpaceAfter(double spaceAfter) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceAfter >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceAfter * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceAfter * 100.0));
        }
        pr.setSpcAft(spc);
    }

    public double getSpaceAfter() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null || !pr.isSetSpcAft()) {
            return 0.0;
        }
        CTTextSpacing spc = pr.getSpcAft();
        if (spc.isSetSpcPct()) {
            return (double)spc.getSpcPct().getVal() * 0.001;
        }
        if (spc.isSetSpcPts()) {
            return (double)(-spc.getSpcPts().getVal()) * 0.01;
        }
        return 0.0;
    }

    public void setLevel(int level) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        pr.setLvl(level);
    }

    public int getLevel() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null) {
            return 0;
        }
        return pr.getLvl();
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }
}

