/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XSLFPictureData;

public class XSLFImageRenderer {
    public boolean drawImage(Graphics2D graphics, XSLFPictureData data, Rectangle2D anchor) {
        try {
            BufferedImage img = ImageIO.read(data.getPackagePart().getInputStream());
            double sx = anchor.getWidth() / (double)img.getWidth();
            double sy = anchor.getHeight() / (double)img.getHeight();
            double tx = anchor.getX();
            double ty = anchor.getY();
            AffineTransform at = new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
            graphics.drawRenderedImage(img, at);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BufferedImage readImage(PackagePart packagePart) throws IOException {
        return ImageIO.read(packagePart.getInputStream());
    }
}

